//---------------------------------------------------------------
// Fichero:  resolucion2.asy
// Objetivo: Dibujar la resolución 2
// Fecha:    L.24.7.2023
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// markrightangle()
import geometry;

// fontsize()
import fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(3.5cm);

// Grosor de las líneas
defaultpen(1);

// Los formatos
pen FormatoTexto=black+fontsize(8pt);
pen FormatoLinea=blue+0.2mm;
pen FormatoPunto=2bp+red;

// Los puntos
pair A=(0,4), B=(6,4), C=(6,0), D=(0,0);
pair M=(A+B)/2;
pair T=intersectionpoint(A--C,M--D);
pair H1=(T.x,4);
pair H2=(T.x,0);

// Los ángulos rectos
markrightangle(T, H1, M, 1mm, gray+0.1mm);
markrightangle(D, H2, T, 1mm, gray+0.1mm);

// Las líneas
draw(H1 -- H2, gray);
draw(A -- B -- C -- D -- cycle);
draw(A -- C);
draw(M -- D);

// Líneas auxiliares
real delta=0.3;
draw(A-(delta,0) -- D-(delta,0), FormatoLinea);
draw(D-(0,delta) -- C-(0,delta), FormatoLinea);

// Los textos
label("A",A,NW,FormatoTexto);
label("B",B,NE,FormatoTexto);
label("C",C,SE,FormatoTexto);
label("D",D,SW,FormatoTexto);
label("M",M,N,FormatoTexto);
label("T",T,2E,FormatoTexto);
label("p",(A+D)/2-(delta,0),W,FormatoTexto);
label("q",(D+C)/2-(0,delta),S,FormatoTexto);
label("h",(H1+T)/2,W,FormatoTexto);
label("k",(H2+T)/2,E,FormatoTexto);

// Marcamos los puntos
dot(A,2bp+FormatoPunto);
dot(B,2bp+FormatoPunto);
dot(C,2bp+FormatoPunto);
dot(D,2bp+FormatoPunto);
dot(M,2bp+FormatoPunto);
dot(T,2bp+FormatoPunto);
