//---------------------------------------------------------------
// Fichero:  ejemplo3.asy
// Objetivo: Dibujar dos triángulos semejantes
// Fecha:    M.18.7.2023
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// markangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(8cm);

// Grosor de las líneas
defaultpen(1);

// Función que devuelve como cadena el valor redondeado en grados de un ángulo
string Ang(pair P1, pair V, pair P2, int e)
    { return string(round(degrees(P2-V)-degrees(P1-V))+360*e)+"$^\circ$"; }

// Función que devuelve el punto medio de un segmento
pair Med(pair P1, pair P2)
    { return (P1+P2)/2; }

// Función que devuelve como cadena la distancia redondeada entre dos puntos
string Dist(pair A, pair B)
    {
    real Longitud=(round(10*length(A-B)))/10;
    return replace(string(Longitud),".",",");
    }

// Los vértices
pair A1=(0,0), B1=(11,1), C1=(3.3,8.9);

// El primer triángulo
path T1 = A1 -- B1 -- C1 -- cycle;
draw(T1);

// El segundo triángulo
transform F=shift(15,9)*rotate(-60)*scale(1.4);
pair A2=F*A1, B2=F*B1, C2=F*C1;
path T2 = F*T1;
draw(T2);

// Los nombres de los vértices
label("M",A1,SW);
label("Q",A2,W);
label("N",B1,E);
label("R",B2,S);
label("P",C1,N);
label("S",C2,NE);

// Los ángulos
markangle(Ang(A1,C1,B1,0), radius=4mm, A1, C1, B1, 0.5bp+blue+fontsize(10pt));
markangle(Ang(A2,C2,B2,0), radius=4mm, A2, C2, B2, 0.5bp+blue+fontsize(10pt));

// Los lados
label(Dist(A1,C1),Med(A1,C1),NW,blue+fontsize(10pt));
label(Dist(A2,C2),Med(A2,C2),N,blue+fontsize(10pt));
label(Dist(B1,C1),Med(B1,C1),NE,blue+fontsize(10pt));
label(Dist(B2,C2),Med(B2,C2),E,blue+fontsize(10pt));
