//---------------------------------------------------------------
// Fichero:  ejemplo2.asy
// Objetivo: Dibujar dos triángulos semejantes
// Fecha:    M.18.7.2023
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(8cm);

// Grosor de las líneas
defaultpen(1);

// Función que devuelve el punto medio de un segmento
pair Med(pair P1, pair P2)
    { return (P1+P2)/2; }

// Función que devuelve como cadena la distancia redondeada entre dos puntos
string Dist(pair A, pair B)
    {
    real Longitud=(round(10*length(A-B)))/10;
    return replace(string(Longitud),".",",");
    }

// Los vértices
pair A1=(0,0), B1=(7.2,0), C1=(4.1,4.15);

// El primer triángulo
path T1 = A1 -- B1 -- C1 -- cycle;
draw(T1);

// El segundo triángulo
transform F=shift(21,4)*rotate(170)*scale(1.5);
pair A2=F*A1, B2=F*B1, C2=F*C1;
path T2 = F*T1;
draw(T2);

// Los nombres de los vértices
label("G",A1,W);
label("J",A2,E);
label("H",B1,E);
label("K",B2,NW);
label("I",C1,N);
label("L",C2,S);

// Los lados
label(Dist(A1,B1),Med(A1,B1),S,blue+fontsize(10pt));
label(Dist(A2,B2),Med(A2,B2),N,blue+fontsize(10pt));
label(Dist(A1,C1),Med(A1,C1),NW,blue+fontsize(10pt));
label(Dist(A2,C2),Med(A2,C2),SE,blue+fontsize(10pt));
label(Dist(B1,C1),Med(B1,C1),NE,blue+fontsize(10pt));
label(Dist(B2,C2),Med(B2,C2),SW,blue+fontsize(10pt));
