//---------------------------------------------------------------
// Fichero:  ejemplo31.asy
// Objetivo: Dibujar dos triángulos semejantes en la posición de Tales
// Fecha:    L.17.7.2023
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5cm);

// Grosor de las líneas
defaultpen(1);

// Los vértices
pair A1=(0,0), B1=(5,0), C1=(1.5,2);

// El primer triángulo
path T1 = A1 -- B1 -- C1 -- cycle;
draw(T1);

// El segundo triángulo
transform F=scale(1.4);
pair A2=F*A1, B2=F*B1, C2=F*C1;
path T2 = F*T1;
draw(T2);

// Los nombres de los vértices
label("A=A'",A1,W);
label("B",B1,S);
label("B'",B2,E);
label("C",C1,NW);
label("C'",C2,N);
