//---------------------------------------------------------------
// Fichero:  cde.asy
// Objetivo: Mostrar el triángulo CDE
// Fecha:    X.12.7.2023
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// fontsize()
include fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(3.5cm);

// Grosor de las líneas
defaultpen(1);

// Los formatos
pen FormatoPunto=2bp+red;
pen FormatoNombrePunto=black+fontsize(8pt);

// Los cuatro puntos más bajos
pair B=(0,0), C=(9,0), D=(0.75,2), E1=(7,2);

// El quinto punto
pair A=intersectionpoint(B--B+5*(D-B), C--C+5(E1-C));

// Los triángulos
draw(A -- B -- C -- cycle);
draw(E1 -- D);

// Los puntos
dot(A,FormatoPunto);
dot(B,FormatoPunto);
dot(C,FormatoPunto);
dot(D,FormatoPunto);
dot(E1,FormatoPunto);

// Los nombres de los vértices
label("A",A,N,FormatoNombrePunto);
label("B",B,SW,FormatoNombrePunto);
label("C",C,SE,FormatoNombrePunto);
label("D",D,NW,FormatoNombrePunto);
label("E",E1,NE,FormatoNombrePunto);

// El triángulo
draw(C -- D -- E1 -- cycle, magenta);
