//---------------------------------------------------------------
// Fichero:  bhADE1.asy
// Objetivo: Ilustrar la base y la altura de ADE por un lado
// Fecha:    X.12.7.2023
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// fontsize()
include fontsize;

// markrightangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(3.5cm);

// Grosor de las líneas
defaultpen(1);

// Los formatos
pen FormatoPunto=2bp+red;
pen FormatoNombrePunto=black+fontsize(8pt);
pen FormatoTexto=fontsize(6pt);

// La distancia para las líneas auxiliares
real delta=0.2;

// Función que devuelve el punto medio de un segmento
pair Med(pair P1, pair P2)
    { return (P1+P2)/2; }

// Función que devuelve un vector normal a un segmento
pair Normal(pair P1, pair P2)
    {
    pair Vector=unit(P2-P1);
    return (Vector.y,-Vector.x);
    }

// Función que dibuja un dato entre dos puntos
void Dato(pair A, pair B, int Sentido, real Ajuste, pen Color, string Texto)
    {
    pair v=Sentido*delta*Normal(A,B);
    pair Direccion=B-A;
    draw(A+v+Ajuste*Direccion -- B+v-Ajuste*Direccion,Color+0.2mm);
    label(Texto,Med(A,B),8v,FormatoTexto);
    }

// Los cuatro puntos más bajos
pair B=(0,0), C=(9,0), D=(0.75,2), E1=(7,2);

// El quinto punto
pair A=intersectionpoint(B--B+5*(D-B), C--C+5(E1-C));

// Los triángulos
draw(A -- B -- C -- cycle);
draw(E1 -- D);

// Los puntos
dot(A,FormatoPunto);
dot(B,FormatoPunto);
dot(C,FormatoPunto);
dot(D,FormatoPunto);
dot(E1,FormatoPunto);

// Los nombres de los vértices
label("A",A,N,FormatoNombrePunto);
label("B",B,SW,FormatoNombrePunto);
label("C",C,SE,FormatoNombrePunto);
label("D",D,W,FormatoNombrePunto);
label("E",E1,E,FormatoNombrePunto);

// La base
Dato(A,D,1,0.05,blue,"y");

// La altura
pair n=10*Normal(A,B);
pair Q=intersectionpoint(A -- B, E1+n -- E1-n);
markrightangle(D, Q, E1, 1.5mm, 0.2mm+gray);
draw(E1 -- Q, blue+0.2mm);
Dato(Q,E1,-1,0.2,white,"h");

// El triángulo
draw(A -- D -- E1 -- cycle, magenta);
