//---------------------------------------------------------------
// Fichero:  triangulos1.asy
// Objetivo: Dibujar dos triángulos en posición de Tales
// Fecha:    L.10.7.2023
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// fontsize()
include fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(0,3cm);

// Grosor de las líneas
defaultpen(1);

// Los cuatro puntos más bajos
pair A=(0,0), B=(9,0), C=(7,2), E1=(0.75,2);

// El quinto punto
pair D=intersectionpoint(A--A+5*(E1-A), B--B+5(C-B));

// Los triángulos
draw(A -- B -- D -- cycle);
draw(E1 -- C, blue);

// Los puntos
pen Formato=2bp+red;
dot(A,2bp+Formato);
dot(B,2bp+Formato);
dot(C,2bp+Formato);
dot(D,2bp+Formato);
dot(E1,2bp+Formato);

// Los nombres de los vértices
pen Formato=black+fontsize(8pt);
label("B",A,SW,Formato);
label("C",B,SE,Formato);
label("E",C,NE,Formato);
label("A",D,N,Formato);
label("D",E1,NW,Formato);
