//---------------------------------------------------------------
// Fichero:  enunciado2.asy
// Objetivo: Dibujar el enunciado 2
// Fecha:    D.9.7.2023
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// fontsize()
include fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(3.5cm);

// Grosor de las líneas
defaultpen(1);

// Función que devuelve el punto medio de un segmento
pair Med(pair P1, pair P2)
    { return (P1+P2)/2; }

// Función que devuelve un vector normal a un segmento
pair Normal(pair P1, pair P2)
    {
    pair Vector=unit(P2-P1);
    return (Vector.y,-Vector.x);
    }

// El triángulo pequeño
pair H=(0,0), L=(-7,2), M=(-2,5);

// El triángulo grande
pair K=scale(1.5)*L;
pair J=scale(1.5)*M;

// Dibujamos los triángulos
draw(H -- J -- K -- cycle);
draw(L -- M);

// Los puntos
pen Formato=2bp+red;
dot(H,2bp+Formato);
dot(J,2bp+Formato);
dot(K,2bp+Formato);
dot(L,2bp+Formato);
dot(M,2bp+Formato);

// Las líneas auxiliares
real delta=0.2;
pen Formato=gray+0.2mm;
pair v=delta*Normal(K,J);
draw(K-v -- J-v,Formato);
pair Direccion=L-M;
draw(L+v-0.1*Direccion -- M+v+0.1*Direccion,Formato);
pair v=delta*Normal(H,J);
draw(H+v -- J+v,Formato);
pair Direccion=H-M;
draw(H-v-0.1*Direccion -- M-v+0.15*Direccion,Formato);
pair v=delta*Normal(H,K);
draw(H-v -- K-v,Formato);
pair Direccion=H-L;
draw(H+v-0.15*Direccion -- L+v+0.15*Direccion,Formato);

// Los nombres de los vértices
pen Formato=black+fontsize(6pt);
label("H",H,SE,Formato);
label("J",J,1.5N,Formato);
label("K",K,W,Formato);
label("L",L,2N,Formato);
label("M",M,2W+N,Formato);

// Las longitudes de los lados
pen Formato=black+fontsize(4pt);
label("8,7",Med(K,J),2NW,Formato);
label("5,8",Med(L,M),3SE,Formato);
label("8,1",Med(H,J),3NE,Formato);
label("5,4",Med(H,M),3W+S,Formato);
label("11,1",Med(H,K),4SW,Formato);
label("7,4",Med(H,L),3NE,Formato);
