//---------------------------------------------------------------
// Fichero:  rectangulos.asy
// Objetivo: Dibujar dos rectángulos semejantes
// Fecha:    L.26.6.2023
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(10cm);

// Grosor de las líneas
defaultpen(1);

// Función que devuelve el punto medio de un segmento
pair Med(pair P1, pair P2)
    { return (P1+P2)/2; }

// El primer rectángulo
pair A1=(0,0), B1=(2,1.3);
draw(box(A1,B1));

// El segundo rectángulo
pair A2=(3,0), B2=(5.5,1.625);
draw(box(A2,B2));

// Las longitudes de los lados
pen Formato=blue+fontsize(16pt);
label("a",(1,0),S,Formato);
label("b",(0,0.65),W,Formato);
label("a'",(4.25,0),S,Formato);
label("b'",(3,0.8125),W,Formato);

// Los nombres de los rectángulos
label("Q",Med(A1,B1),Formato);
label("Q'",Med(A2,B2),Formato);
