//---------------------------------------------------------------
// Fichero:  cuadrilatero.asy
// Objetivo: Dibujar el problema del cuadrilátero
// Fecha:    S.2.9.2023
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// markrightangle()
import geometry;

// fontsize()
import fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(0,2.5cm);

// Grosor de las líneas
defaultpen(1);

// El cuadrilátero
pair A=(0,0), B=(15,0), C=(15,3), D=(0,6);
draw(A -- B -- C -- D -- cycle);

// Los ángulos rectos
pen FormatoAngulo = 1bp+blue;
markrightangle(B, A, D, 5mm, FormatoAngulo);
markrightangle(C, B, A, 5mm, FormatoAngulo);

// Las longitudes
pen FormatoTexto = fontsize(14pt)+blue;
label("6", (0,3), W, FormatoTexto);
label("3", (15,1.5), E, FormatoTexto);
