//---------------------------------------------------------------
// Fichero:  enunciado7.asy
// Objetivo: Dibujar el enunciado 7
// Fecha:    M.25.7.2023
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// fontsize()
import fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(0,3.5cm);

// Grosor de las líneas
defaultpen(1);

// Los formatos
pen FormatoTexto=blue+fontsize(8pt);
pen FormatoPunto=2bp+red;

// Función que devuelve el punto medio de un segmento
pair Med(pair P1, pair P2)
    { return (P1+P2)/2; }

// Función que devuelve un vector normal a un segmento
pair Normal(pair P1, pair P2)
    {
    pair Vector=unit(P2-P1);
    return (Vector.y,-Vector.x);
    }

// Función que devuelve el producto escalar de dos vectores
real PE(pair z, pair w)
    { return z.x*w.y-z.y*w.x; }

// Función que da un segmento entre dos puntos opuesto a un tercero
void Segmento(pair A, pair B, pair C, string Texto)
    {
    pair v=Normal(A,B);
    pair D=Med(A,B)+v;
    if ( sgn(PE(A-C,B-C)) == sgn(PE(A-D,B-D)) )
        { v=-v; }
    label(Texto,Med(A,B),v,FormatoTexto);
    }

// Los puntos
pair A=(0,0), B=(8,0);
pair C=intersectionpoint(circle(A,6),circle(B,7));
pair D=B+(16/7)*(C-B);

// Las líneas
draw(A -- B -- C -- cycle);
draw(A -- D -- C);

// Los segmentos
Segmento(A,B,C,"8");
Segmento(A,C,B,"6");
Segmento(B,C,A,"7");
Segmento(C,D,A,"x");
Segmento(A,D,C,"y");

// Los puntos
dot(A,FormatoPunto);
dot(B,FormatoPunto);
dot(C,FormatoPunto);
dot(D,FormatoPunto);

// Los nombres
label("A",A,SW,fontsize(8pt));
label("B",B,SE,fontsize(8pt));
label("C",C,NE,fontsize(8pt));
label("D",D,N,fontsize(8pt));
