//---------------------------------------------------------------
// Fichero:  enunciado4.asy
// Objetivo: Dibujar el enunciado 4
// Fecha:    M.25.7.2023
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// fontsize()
import fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(0,3.5cm);

// Grosor de las líneas
defaultpen(1);

// Los formatos
pen FormatoTexto=blue+fontsize(8pt);
pen FormatoPunto=2bp+red;

// Función que devuelve el punto medio de un segmento
pair Med(pair P1, pair P2)
    { return (P1+P2)/2; }

// Función que devuelve como cadena la distancia redondeada entre dos puntos
string Dist(pair A, pair B)
    {
    real Longitud=(round(10*length(A-B)))/10;
    return replace(string(Longitud),".",",");
    }

// Función que devuelve un vector normal a un segmento
pair Normal(pair P1, pair P2)
    {
    pair Vector=unit(P2-P1);
    return (Vector.y,-Vector.x);
    }

// Función que devuelve el producto escalar de dos vectores
real PE(pair z, pair w)
    { return z.x*w.y-z.y*w.x; }

// Función que da un segmento entre dos puntos opuesto a un tercero
void Segmento(pair A, pair B, pair C, string Texto)
    {
    pair v=Normal(A,B);
    pair D=Med(A,B)+v;
    if ( sgn(PE(A-C,B-C)) == sgn(PE(A-D,B-D)) )
        { v=-v; }
    label(Texto,Med(A,B),v,FormatoTexto);
    }

// Los puntos
pair A=(0,0), B=(73,0), C=(5,12);
pair C=intersectionpoint(circle(A,50),circle(B,69));
pair D=B+69*Normal(B,C);
pair E=C+69*Normal(B,C);
pair F=intersectionpoint(A--D,C--B);
pair G=intersectionpoint(A--E,C--B);

// Las líneas
draw(A -- B -- C -- cycle);
draw(B -- D -- E -- C);
draw(A -- D, gray);
draw(A -- E, gray);

// Los segmentos
Segmento(A,B,C,"73");
Segmento(A,C,B,"50");
Segmento(B,D,C,"69");
Segmento(D,E,A,"69");
Segmento(C,E,B,"69");
Segmento(F,G,A,"x");

// Los puntos
dot(F,FormatoPunto);
dot(G,FormatoPunto);
