//---------------------------------------------------------------
// Fichero:  enunciado3.asy
// Objetivo: Dibujar el enunciado 3
// Fecha:    L.24.7.2023
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// fontsize()
import fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(0,3.5cm);

// Grosor de las líneas
defaultpen(1);

// Los formatos
pen FormatoTexto=black+fontsize(8pt);

// Los puntos
pair A=(0,3), B=(5,3), C=(5,0), D=(0,0);
pair M=(0,1.5), E1=(10,6);

// El rectángulo
draw(A -- B -- C -- D -- cycle);

// Las líneas
draw(A -- E1);
draw(B -- E1);
draw(D -- B);
draw(M -- B);

// Los puntos
label("A",A,NW,FormatoTexto);
label("B",B,SE,FormatoTexto);
label("C",C,SE,FormatoTexto);
label("D",D,SW,FormatoTexto);
label("M",M,W,FormatoTexto);
label("E",E1,E,FormatoTexto);
