//---------------------------------------------------------------
// Fichero:  enunciado2.asy
// Objetivo: Dibujar el enunciado 2
// Fecha:    L.24.7.2023
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// fontsize()
import fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(0,3.5cm);

// Grosor de las líneas
defaultpen(1);

// Los formatos
pen FormatoTexto=black+fontsize(8pt);

// Los puntos
pair A=(0,4), B=(6,4), C=(6,0), D=(0,0);
pair M=(1.5,4);
pair T=intersectionpoint(A--C,M--D);

// El triángulo
fill(C -- T -- D -- cycle, gray);

// Las líneas
draw(A -- B -- C -- D -- cycle);
draw(A -- C);
draw(M -- D);

// Los puntos
label("A",A,NW,FormatoTexto);
label("B",B,NE,FormatoTexto);
label("C",C,SE,FormatoTexto);
label("D",D,SW,FormatoTexto);
label("M",M,N,FormatoTexto);
