//---------------------------------------------------------------
// Fichero:  poligono3.asy
// Objetivo: Mostrar la fase 3 del polígono
// Fecha:    J.29.6.2023
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(4cm);

// Grosor de las líneas
defaultpen(1);

// Los vértices
pair A=(0,0), B=0.75*dir(10), C=(2*B.x,0), D=(C.x,1),
     E=(B.x,1-B.y), F=(0,1);

// Los polígonos
path Interior=A -- B -- C -- D -- E -- F -- cycle;
transform F=scale(1.4);
path Exterior=F*Interior;
pair Mi=(A+D)/2;
pair Me=(F*A+F*D)/2;

// Dibujamos el exterior
filldraw(shift(Mi-Me)*Exterior,gray,red);

// Dibujamos el interior
filldraw(Interior,white,black);
