//---------------------------------------------------------------
// Fichero:  corona.asy
// Objetivo: Dibujar un cuarto de corona circular
// Fecha:    X.28.6.2023
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(4cm);

// Grosor de las líneas
defaultpen(1);

// El cuarto de corona
pair T=(0,0);
filldraw(buildcycle(arc(T,1,0,180), (1,0) -- (2,0), arc(T,2,0,180),
         (0,1) -- (0,2)),gray);

// Los círculos
draw(circle(T,1));
draw(circle(T,2));

// Los segmentos
draw((1,0) -- T,blue);
draw((1,0) -- (2,0));
draw((0,1) -- (0,2));

// Los puntos
dot(T,3bp+black);
dot((1,0),3bp+black);
dot((2,0),3bp+black);

// Los textos
label("a",(0.5,0),S,blue);
label("a",(1.5,0),S,blue);
