//---------------------------------------------------------------
// Fichero:  enunciado11.asy
// Objetivo: Dibujar el enunciado 11
// Fecha:    J.20.7.2023
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// markangle()
import geometry;

// fontsize()
import fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5.8cm);

// Grosor de las líneas
defaultpen(1);

//----------- Los datos de este enunciado

// Longitudes de los tres lados del triángulo original
real a=17.5, b=19.5, c=18;

// Razón de semejanza para obtener el triángulo generado
real Razon=0.8;

// Ángulos de giro de los dos triángulos
int Giro1=-10, Giro2=190;

// Desplazamiento del triángulo generado
pair Desplazamiento=(35,11);

// Si el triángulo generado debe obtenerse con una simetría
bool Simetria=false;

// Los formatos
pen FormatoAngulo=0.5bp+blue+fontsize(8pt);
pen FormatoLado=blue+fontsize(8pt);

//----------- Fin de los datos

// Función que devuelve como cadena el valor redondeado en grados de un ángulo
string Ang(pair P1, pair V, pair P2)
    {
    int Valor=round(degrees(P2-V)-degrees(P1-V));
    if ( Valor<0 )  { Valor += 360; }
    return string(Valor)+"$^\circ$";
    }

// Función que devuelve el punto medio de un segmento
pair Med(pair P1, pair P2)
    { return (P1+P2)/2; }

// Función que devuelve como cadena la distancia redondeada entre dos puntos
string Dist(pair A, pair B)
    {
    real Longitud=(round(10*length(A-B)))/10;
    return replace(string(Longitud),".",",");
    }

// Función que devuelve un vector normal a un segmento
pair Normal(pair P1, pair P2)
    {
    pair Vector=unit(P2-P1);
    return (Vector.y,-Vector.x);
    }

// Función que devuelve el producto escalar de dos vectores
real PE(pair z, pair w)
    { return z.x*w.y-z.y*w.x; }

// Función que da un lado entre dos puntos opuesto a la posición del tercero
void Lado(pair A, pair B, pair C, bool Incognita)
    {
    pair v=Normal(A,B);
    pair D=Med(A,B)+v;
    if ( sgn(PE(A-C,B-C)) == sgn(PE(A-D,B-D)) )
        { v=-v; }
    string Texto=Dist(A,B);
    if ( Incognita ) { Texto="x"; }
    label(Texto,Med(A,B),v,FormatoLado);
    }

// Función que da un ángulo definido por tres puntos
void Angulo(pair A, pair V, pair B, bool Incognita)
    {
    string Texto=Ang(A,V,B);
    if ( Incognita ) { Texto="x"; }
    markangle(Texto, radius=6mm, A, V, B, FormatoAngulo);
    }

// Los vértices del triángulo original
pair A1=(0,0), B1=(a,0);
pair C1=intersectionpoint(circle(A1,b),circle(B1,c));
A1=rotate(Giro1)*A1;
B1=rotate(Giro1)*B1;
C1=rotate(Giro1)*C1;

// El triángulo original
path T1 = A1 -- B1 -- C1 -- cycle;
draw(T1);

// La trasformación para obtener el triángulo generado
transform F=rotate(Giro2)*scale(Razon);
if ( Simetria ) { F=reflect(C1+(0,1),C1-(0,1))*F; }
F=shift(Desplazamiento)*F;

// El triángulo generado
pair A2=F*A1, B2=F*B1, C2=F*C1;
path T2 = F*T1;
draw(T2);

// Los ángulos
Angulo(C1,B1,A1,false);
Angulo(C2,B2,A2,false);

// Los lados
Lado(A1,B1,C1,false);
Lado(A1,C1,B1,false);
Lado(B1,C1,A1,false);
Lado(A2,B2,C2,false);
Lado(A2,C2,B2,true);
Lado(B2,C2,A2,false);
