//---------------------------------------------------------------
// Fichero:  enunciado13.asy
// Objetivo: Dibujar el enunciado 13
// Fecha:    S.17.6.2023
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(4.8cm);

// Grosor de las líneas
defaultpen(1);

// La figura original
pair V[]={(0,0), (4,0), (3,2), (4,4), (0,4), (1,2)};
guide Original;
for ( int i=0 ; i<V.length ; ++i )
    { Original = Original -- V[i]; }
Original = Original -- cycle;

// La transformación
transform F=shift(4.5,-0.4)*scale(1.2)*rotate(90,(2,2));

// La figura nueva
pair V[]={(0,0), (4,0), (3.5,2), (4,4), (0,4), (0.5,2)};
guide Nueva;
for ( int i=0 ; i<V.length ; ++i )
    { Nueva = Nueva -- V[i]; }
Nueva = Nueva -- cycle;
path Nueva=F*Nueva;

// Dibujamos
draw(Original);
draw(Nueva);

