//---------------------------------------------------------------
// Fichero:  prisma.asy
// Objetivo: Mostrar el prisma
// Fecha:    L.15.5.2023
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// fontsize()
import fontsize;

// Geometría 3D
import three;

// Obtendremos un archivo PNG
settings.outformat="png";
settings.render=6;

// Tamaño de la imagen
size(3cm);

// Punto de proyección
currentprojection=orthographic(5,4,3);

// Punto de luz
currentlight=light(10,0,10);

/////////////////////////////////////////
// https://asy.marris.fr/asymptote/Positions_relatives/index.html
//         #fig_pa01_251211_plan_droite_perpendiculaires
void angledroit(picture pic=currentpicture,
                triple pO, triple pI, triple pJ, real size=.5, pen p=black,
                projection P=currentprojection){
     triple imI=pO+size*unit(pI-pO),
            imJ=pO+size*unit(pJ-pO),
            imK=imI+imJ-pO;
            draw(imI--imK--imJ,p);
}
/////////////////////////////////////////

// Número de vértices de las bases
int N=6;

// Altura
real Altura=0.75;

// Las bases
path3 PoligonoBase1 = path3(rotate(10)*polygon(N));
path3 PoligonoBase2 = shift(Altura*Z)*PoligonoBase1;

// Las caras del prisma
path3[] Caras={PoligonoBase1, PoligonoBase2};
for (int i=0; i<N; ++i)
    { Caras.push(point(PoligonoBase1,i)--point(PoligonoBase1,i+1)--
      point(PoligonoBase2,i+1)--point(PoligonoBase2,i)--cycle); }

// Dibujamos las caras
draw(surface(Caras),lightgray+opacity(.7));

// Dibujamos las aristas
draw(Caras,1.5bp+black);

// Marcamos y nombramos los vértices que necesitamos
pen FormatoTexto=fontsize(6pt)+Helvetica(series="m",shape="n");

triple A=(point(PoligonoBase1,1)+point(PoligonoBase1,2))/2;
dot(A,blue);
label("R",A,S,FormatoTexto);

triple B=point(PoligonoBase1,2);
dot(B,blue);
label("S",B,S,FormatoTexto);

triple C=(point(PoligonoBase1,1)+point(PoligonoBase1,4))/2;
dot(C,blue);
label("T",C,W,FormatoTexto);

// Un triángulo rectángulo
draw(A--B--C--cycle,blue);

// El ángulo recto
angledroit(A,B,C,.2,1bp+blue);
