//---------------------------------------------------------------
// Fichero:  long-int.asy
// Objetivo: Dibujar la figura para calcular la longitud de un
//           segmento tangente interior a dos
//           circunferencias exteriores
// Fecha:    L.8.5.2023
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// fontsize()
import fontsize;

// markrightangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5cm);

// Grosor de las líneas
defaultpen(1);

// Centros y los radios de las dos circunferencias
pair T1=(0,0), T2=(4,0);
real R1=1, R2=1.8;

// Las circunferencias
path C1=circle(T1,R1); draw(C1);
path C2=circle(T2,R2); draw(C2);

// Los centros
dot(T1,2bp+black);
dot(T2,2bp+black);

// Circunferencia auxiliar de centro T2 y radio R1+R2
path Exterior=circle(T2,R1+R2);

// Circunferencia auxiliar de diámetro T1--T2
path Diametral=circle((T1+T2)/2,length(T1-T2)/2);

// El punto de corte superior de las dos circunferencias auxiliares
pair Aux=intersectionpoint(Exterior,Diametral);

// Los primeros puntos de tangencia
pair G2=intersectionpoint(C2, T2--(T2+(R2+1)*(Aux-T2)));
pair G1=intersectionpoint(C1, T1--(T1+(R1+1)*(T2-Aux)));

// Los segundos puntos de tangencia
pair H1=(G1.x,-G1.y);
pair H2=(G2.x,-G2.y);

// Los segmentos tangentes
draw(G1--G2,blue);

// Los puntos de tangencia
dot(G1,2bp+red);
dot(G2,2bp+red);

// Uniónes del centro y el punto de tangencia
pen Punteado = linetype(new real[] {2,2});
draw(T1 -- G1, Punteado);

// El segmento tangente
draw(G1--G2,blue);

// El triángulo rectángulo
draw(T1--T2--Aux--T1,heavygreen);

// Marcamos los ángulos rectos
markrightangle(G2, G1, T1, 1.5mm, 0.3bp+black);
markrightangle(G1, G2, T2, 1.5mm, 0.3bp+black);
markrightangle(T1, Aux, T2, 1.5mm, 0.3bp+black);

// Los centros
dot(T1,2bp+red);
dot(T2,2bp+red);

// Los puntos de tangencia
dot(G1,2bp+red);
dot(G2,2bp+red);

// El punto de corte
dot(Aux,2bp+red);

// Los nombres de tres vértices
pen FormatoTexto=fontsize(8pt)+Helvetica(series="m",shape="n");
label("A", T1, SW, black+FormatoTexto);
label("B", T2, SE, black+FormatoTexto);
label("C", Aux, 2W, black+FormatoTexto);
