//---------------------------------------------------------------
// Fichero:  vidriera.asy
// Objetivo: Representar la vidriera
// Fecha:    D.14.5.2023
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(3cm);

// Grosor de las líneas
defaultpen(1);

// Los colores usados
pen Azul = mediumblue;
pen Rojo = lightred;
pen Verde = lightgreen;

// La circunferencia grande
path Grande = circle((0,0),2);

// La circunferencia pequeña
path Pequena = circle((0,0),1);

// Las cuatro copias que usamos de la circunferencia pequeña
path P1=shift(1,0)*Pequena;
path P2=shift(0,1)*Pequena;
path P3=shift(-1,0)*Pequena;
path P4=shift(0,-1)*Pequena;

// El círculo grande
fill(Grande, Azul);

// Los círculos pequeños
fill(P1,Rojo);
fill(P2,Rojo);
fill(P3,Rojo);
fill(P4,Rojo);

// Intersecciones de las circunferencias pequeñas entre sí
fill(buildcycle(P1,P2), Verde);
fill(buildcycle(P2,P3), Verde);
fill(buildcycle(P4,P3), Verde);
fill(buildcycle(P4,P1), Verde);

// Dibujamos las circunferencias
draw(P1);
draw(P2);
draw(P3);
draw(P4);
draw(Grande);
