//---------------------------------------------------------------
// Fichero:  cuadrilatero1.asy
// Objetivo: Dibujar un cuadrilátero
// Fecha:    X.10.5.2023
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5cm);

// Grosor de las líneas
defaultpen(1);

// Los vértices
pair A=(0,0), B=(60,0), C=(60,25), D=(9.6,37.8);

// Una diagonal
pen Punteado = linetype(new real[] {2,2});
draw(B -- D, Punteado+gray);

// El cuadrilátero
draw(A -- B -- C -- D -- A);

// Los nombres de los vértices
pen FormatoTexto=fontsize(8pt)+Helvetica(series="m",shape="n");
label("A", A, W, black+FormatoTexto);
label("B", B, E, black+FormatoTexto);
label("C", C, NE, black+FormatoTexto);
label("D", D, N, black+FormatoTexto);

// Las dimensiones
label("60", (A+B)/2, S, black+FormatoTexto);
label("25", (C+B)/2, E, black+FormatoTexto);
label("52", (C+D)/2, N, black+FormatoTexto);
label("39", (A+D)/2, W, black+FormatoTexto);
label("63", (B+D)/2, SW, black+FormatoTexto);
