#!/usr/bin/python
# coding: utf-8

#--------------------------------------------------------------------
# Fichero:  moneda.py
# Objetivo: Lanza una moneda el número de veces especificado
# Autor:    Pedro Reina <pedro@pedroreina.net>
# Fecha:    X.17.1.2024
# Atención: solo se ha probado en Python 2.7
# Licencia: Dominio público
#           https://creativecommons.org/publicdomain/zero/1.0/
#--------------------------------------------------------------------

#------------------------------------------------
# Módulos
#------------------------------------------------

# Para leer la línea de órdenes
import sys

# Para obtener números aleatorios
import random

#------------------------------------------------
# El programa
#------------------------------------------------

# Leemos el número de veces de la línea de órdenes
Total = int(sys.argv[1])

# Frecuencia absoluta
FA = {'C': 0, 'X': 0}

# Repetimos el lanzamiento
for i in range(Total):
    Numero = random.random()
    Resultado = 'C' if Numero<.5 else 'X'
    FA[Resultado] += 1

# Imprimimos el resultado
for Resultado in FA:
    print Resultado, float(FA[Resultado])/Total
