#!/usr/bin/python
# coding: utf-8

#--------------------------------------------------------------------
# Fichero:  urna.py
# Objetivo: Elige una bola de una urna el número de veces especificado
# Autor:    Pedro Reina <pedro@pedroreina.net>
# Fecha:    M.16.1.2024
# Atención: solo se ha probado en Python 2.7
# Licencia: Dominio público
#           https://creativecommons.org/publicdomain/zero/1.0/
#--------------------------------------------------------------------

#------------------------------------------------
# Módulos
#------------------------------------------------

# Para leer la línea de órdenes
import sys

# Para obtener números aleatorios
import random

#------------------------------------------------
# El programa
#------------------------------------------------

# La urna
Urna = ['V3','V4','V5','V6','V7','A4','A5','A6','R5','R6','R7','R8']

# Los sucesos
S = ['V6','A6','R5','R6','R7','R8']
T = ['A4','A5','R5']

# Leemos el número de veces de la línea de órdenes
Total = int(sys.argv[1])

# Las frecuencias absolutas
FS = FT = 0

# Repetimos el lanzamiento
for i in range(Total):
    Elemento = random.choice(Urna)
    if Elemento in S: FS+=1
    if Elemento in T: FT+=1
    print Elemento,
print
print 'Frecuencia de S', FS
print 'Frecuencia de T', FT
