//---------------------------------------------------------------
// Fichero:  figura2.asy
// Objetivo: Representar el polígono de frecuencias acumuladas
//           y uno de sus valores
// Fecha:    D.17.12.2023
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// fontsize()
import fontsize;

// Tamaño de la imagen
size(5.7cm);

// Grosor de las líneas
defaultpen(1);

// Los valores de los extremos de los intervalos
string Valor[]={'45', '50', '55', '60', '65', '70', '75', '80'};
int TotalVal = Valor.length;

// Las frecuencias absolutas acumuladas
int Frecuencia[]={0,75,164,257,377,570,692,750};
int MaxFre=max(Frecuencia);
int TotalFre = Frecuencia.length;

// Escala para modificar los porcentajes
real Escala=0.007;

// Los ejes
draw((0,0)--(TotalVal+.5,0));
draw((0,0)--(0,Escala*(MaxFre+.5)));

// Formatos
pen FormatoTexto=blue+fontsize(6pt);
pen FormatoTextoResaltado=deepmagenta+fontsize(6pt);
pen FormatoPunto=red+2bp;
pen FormatoSegmento=gray+0.5bp;
pen FormatoTitulo=deepblue+fontsize(6pt)+Helvetica(series="b",shape="n");

// El eje de ordenadas
for ( int i=0 ; i<TotalFre ; ++i )
    {
    int Valor=Frecuencia[i];
    label(string(Valor), (0,Escala*Valor), 2*W, FormatoTexto);
    draw((-0.05,Escala*Valor)--(0.05,Escala*Valor));
    }
real V=Escala*630;
label('630', (0,V), 2*W, FormatoTextoResaltado);
draw((-0.05,V)--(0.05,V));

// La marca de que cortamos un trozo de eje de abscisas
fill(box((0.4,-0.1),(0.6,0.1)),white);
draw((0.35,-0.1)--(0.45,0.1));
draw((0.55,-0.1)--(0.65,0.1));

// Los segmentos
for ( int i=1 ; i<TotalVal ; ++i )
    {
    draw((i+1,0)--(i+1,Escala*Frecuencia[i]),FormatoSegmento);
    draw((i,Escala*Frecuencia[i-1])--(i+1,Escala*Frecuencia[i]));
    }

// El eje de absisas
for ( int i=0 ; i<TotalVal ; ++i )
    {
    label(Valor[i], (i+1,0), 1.5*S, FormatoTexto);
    draw((i+1,-0.05)--(i+1,0.05));
    }
real X=6.5;
label('?', (X,0), 1.5*S, FormatoTextoResaltado);
draw((X,-0.05)--(X,0.05));

// El segmento que nos interesa
draw((6,Escala*Frecuencia[5])--(7,Escala*Frecuencia[6]), heavygreen+2bp);

// Los puntos
for ( int i=1 ; i<=TotalVal ; ++i )
    { dot((i,Escala*Frecuencia[i-1]), FormatoPunto); }

// Dos flechas y un punto
dot((X,V),deepmagenta+3bp);
draw((0.2,V) -- (X-0.2,V), magenta+0.5bp, Arrow(HookHead,1.5bp));
draw((X,V-0.2) -- (X,0.2), magenta+0.5bp, Arrow(HookHead,1.5bp));

// El rótulo
label('Figura 2', (TotalFre/2,Escala*MaxFre), S, FormatoTitulo);
