#!/usr/bin/python
# coding: utf-8

#--------------------------------------------------------------------
# Fichero:  cuartiles.py
# Objetivo: Inventar un conjunto de datos y calcular sus cuartiles
#           de variaciación de un conjunto de datos
# Autor:    Pedro Reina <pedro@pedroreina.net>
# Fecha:    J.7.12.2023
# Atención: solo se ha probado en Python 2.7
# Licencia: Dominio público
#           https://creativecommons.org/publicdomain/zero/1.0/
#--------------------------------------------------------------------

#------------------------------------------------
# Módulos
#------------------------------------------------

# Para leer la línea de órdenes
import sys

# random.choice()
import random

#------------------------------------------------
# Funciones
#------------------------------------------------
def CalculaValor(x):
    ParteEntera = int(x)
    if ParteEntera==x:
        Respuesta=Datos[ParteEntera-1]
    else:
        Respuesta=(Datos[ParteEntera-1]+Datos[ParteEntera])/2.0
    return Respuesta

#------------------------------------------------
# El programa
#------------------------------------------------

# Leemos algunos datos de la línea de órdenes
Num = int(sys.argv[1])
Min = int(sys.argv[2])
Max = int(sys.argv[3])

# Inventamos datos
Valido = range(Min, Max+1)
Datos = []
for i in range(Num):
    Datos.append(random.choice(Valido))

# Los ordenamos
Datos.sort()

# Las posiciones de los cuartiles
L1 = (Num+1)/4.0 if Num%2 else (Num+2)/4.0
L2 = (Num+1)/2.0
L3 = 3*(Num+1)/4.0 if Num%2 else (3*Num+2)/4.0

# Los valores de los cuartiles
Q1 = CalculaValor(L1)
Q2 = CalculaValor(L2)
Q3 = CalculaValor(L3)

# Informamos
print 'Número de datos:', Num
print 'Mínimo:', Min
print 'Máximo:', Max
print 'Datos ordenados:'
print Datos
print 'Posiciones de los cuartiles:', L1, L2, L3
print 'Valores de los cuartiles:', Q1, Q2, Q3
