#!/usr/bin/python
# coding: utf-8

#--------------------------------------------------------------------
# Fichero:  m-dt-cv.py
# Objetivo: Calcula la media, la desviación típica y el coeficiente
#           de variación de un conjunto de datos
# Autor:    Pedro Reina <pedro@pedroreina.net>
# Fecha:    X.6.12.2023
# Atención: solo se ha probado en Python 2.7
# Licencia: Dominio público
#           https://creativecommons.org/publicdomain/zero/1.0/
#--------------------------------------------------------------------

#------------------------------------------------
# Módulos
#------------------------------------------------

# Para leer la línea de órdenes
import sys

# sqrt()
import math

#------------------------------------------------
# El programa
#------------------------------------------------

# Leemos el nombre del archivo con los datos de la línea de órdenes
Nombre = sys.argv[1]

# Leemos los datos del archivo
with open(Nombre) as Fichero:
    Datos = Fichero.readlines()

# El número de datos
Num = len(Datos)

# Los convertimos en números reales
Datos = map(float,Datos);

# Calculamos los cuadrados de los datos
Cuadrados = map(lambda x: x*x,Datos)

# Calculamos la media
Media = sum(Datos)/Num

# Calculamos la desviación típica
Sigma = math.sqrt((sum(Cuadrados)/Num)-Media**2)

# Calculamos el coeficiente de variación
CV = Sigma/Media

# Damos el resultado
print 'Número de datos:', Num
print 'Media:', str(Media).replace('.', ',')
print 'Desviacion típica:', str(Sigma).replace('.', ',')
print 'Coeficiente de variación:', str(CV).replace('.', ',')
