//---------------------------------------------------------------
// Fichero:  ejemplo2.asy
// Objetivo: Representar el ejemplo 2
// Fecha:    V.10.11.2023
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Gaussrand()
include stats;

// Tamaño de la imagen
size(4cm);

// El radio de la diana
int R=5;

// Un punto cualquiera
pair P;

// Función que devuelve un punto dentro de la diana
pair Disparo()
    {
    bool Sigue = true;
    while ( Sigue )
        {
        real Lejania=0.6;
        P=(Lejania*Gaussrand(),Lejania*Gaussrand())+(R/2,R/2);
        if ( length(P)<R )  { Sigue = false; }
        }
    return P;
    }

// La diana
for ( int i=1 ; i<=R ; ++i )
    { draw(scale(i)*unitcircle, 0.75bp+gray); }

// Iniciamos el generador de números aleatorios
srand(15);

// Obtenemos 10 disparos
pen Formato=2bp+blue;
for ( int i=0 ; i<10 ; ++i )
    {
    P=Disparo();
    dot(P,Formato);
    }

