//---------------------------------------------------------------
// Fichero:  ejercicio3.asy
// Objetivo: Representar el polígono de frecuencias acumuladas
// Fecha:    X.20.12.2023
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// fontsize()
import fontsize;

// Tamaño de la imagen
size(7cm);

// Grosor de las líneas
defaultpen(1);

// Los valores de los extremos de los intervalos
string Valor[]={'30', '38', '46', '54', '62', '70', '78', '86'};
int TotalVal = Valor.length;

// Las frecuencias absolutas acumuladas
int Frecuencia[]={0,251,529,851,1093,1330,1531,1720};
int MaxFre=max(Frecuencia);
int TotalFre = Frecuencia.length;

// Escala para modificar los porcentajes
real Escala=5/MaxFre;

// Los ejes
draw((0,0)--(TotalVal+.5,0));
draw((0,0)--(0,Escala*(MaxFre+.5)));

// Formatos
pen FormatoTexto=blue+fontsize(6pt);
pen FormatoPunto=red+2bp;
pen FormatoSegmento=gray+0.5bp;

// Los segmentos
for ( int i=1 ; i<TotalVal ; ++i )
    {
    draw((i+1,0)--(i+1,Escala*Frecuencia[i]),FormatoSegmento);
    draw((i,Escala*Frecuencia[i-1])--(i+1,Escala*Frecuencia[i]));
    draw((i+1,Escala*Frecuencia[i])--(0,Escala*Frecuencia[i]),FormatoSegmento);
    }

// El eje de ordenadas
for ( int i=0 ; i<TotalFre ; ++i )
    {
    int Valor=Frecuencia[i];
    label(string(Valor), (0,Escala*Valor), 2*W, FormatoTexto);
    draw((-0.05,Escala*Valor)--(0.05,Escala*Valor));
    }

// El eje de absisas
for ( int i=0 ; i<TotalVal ; ++i )
    {
    label(Valor[i], (i+1,0), 1.5*S, FormatoTexto);
    draw((i+1,-0.05)--(i+1,0.05));
    }

// La marca de que cortamos un trozo de eje de abscisas
fill(box((0.4,-0.1),(0.6,0.1)),white);
draw((0.35,-0.1)--(0.45,0.1));
draw((0.55,-0.1)--(0.65,0.1));

// Los puntos
for ( int i=1 ; i<=TotalVal ; ++i )
    { dot((i,Escala*Frecuencia[i-1]), FormatoPunto); }
