//---------------------------------------------------------------
// Fichero:  golf.asy
// Objetivo: Dibujar el diagrama de caja y bigotes del golf
// Fecha:    L.11.12.2023
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// fontsize()
import fontsize;

// Tamaño de la imagen
size(16cm);

// Grosor de las líneas
defaultpen(1);

// Los valores estadísticos
real Md=282, Q1=279, Q3=285, LI=270, LS=294;

// Los valores visuales
real Ancho=4, Sep=0.4;

// La caja
draw(box((Q1,0),(Q3,Ancho)));

// La mediana
draw((Md,0)--(Md,Ancho));

// Bigote izquierdo
draw((LI,Ancho/2)--(Q1,Ancho/2));
draw((LI,Ancho/2+Sep)--(LI,Ancho/2-Sep));

// Bigote derecho
draw((Q3,Ancho/2)--(LS,Ancho/2));
draw((LS,Ancho/2+Sep)--(LS,Ancho/2-Sep));

// Valores atípicos
path Hex=shift(0,Ancho/2)*scale(0.25)*polygon(6);
filldraw(shift(268,0)*Hex);
filldraw(shift(269,0)*Hex);
filldraw(shift(296,0)*Hex);

// La escala
draw((268,-2) -- (296,-2), blue);
pen Formato=fontsize(10pt)+blue;
for ( int i=268 ; i<297 ; i+=2 )
    {
    draw((i,-2+Sep/2) -- (i,-2-Sep/2), blue);
    label(string(i),(i,-2-Sep),S,Formato);
    }
