//---------------------------------------------------------------
// Fichero:  esquema.asy
// Objetivo: Representar el esquema del problema
// Fecha:    L.20.6.2022
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para cambiar el tamaño del texto
import fontsize;

// Para los caracteres no ASCII
import unicode;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(4cm);

// Grosor de las líneas
defaultpen(1);

// La anchura que marca el total
real AnchuraTotal=7;

// La anchura que marca la fracción de la parte
real AnchuraParte=AnchuraTotal*0.28;

// El rectángulo que marca el numerador
filldraw(box((0,0),(AnchuraParte,3)), mediumgray);

// El rectángulo que marca el total
draw(box((0,0), (AnchuraTotal,3)));

// La separación entre las flechas y el objeto
real Separacion = 0.3;

// Las flechas
draw((0,-Separacion) -- (AnchuraParte,-Separacion),
     blue, Arrows(HookHead,5bp), Bars(2mm));
draw((0,3+Separacion) -- (AnchuraTotal,3+Separacion),
     blue, Arrows(HookHead,5bp), Bars(2mm));

// Las etiquetas
label("¿Total?", (AnchuraTotal/2,3+3*Separacion), fontsize(10pt));
label("0,28...", (AnchuraParte/2,1.5), fontsize(10pt));
label("1\hspace{1pt}h", (AnchuraParte/2,-3*Separacion), fontsize(10pt));
