//---------------------------------------------------------------
// Fichero:  mosaicos.asy
// Objetivo: Mostrar una sucesión de mosaicos
// Fecha:    J.8.9.2022
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Para fontsize()
import fontsize;

// Tamaño de la imagen
size(10cm);

// Grosor de las líneas
defaultpen(1);

// Función que representa un mosaico según su número de lados
void Mosaico(int Num, pair Base)
    {
    // La base de cuadrados blancos
    for (int i=0 ; i<Num ; ++i)
        {
        for (int j=0 ; j<Num ; ++j)
            { draw(shift((i,j)+Base)*unitsquare,black); }
        }

    // La diagonal
    for (int i=0 ; i<Num ; ++i)
        { filldraw(shift((i,i)+Base)*unitsquare,gray,black); }

    // La fila central
    for (int i=0 ; i<Num ; ++i)
        { filldraw(shift((i,floor(Num/2))+Base)*unitsquare,gray,black); }

    // Media columna derecha
    for (int i=0 ; i<Num/2 ; ++i)
        { filldraw(shift((Num-1,i)+Base)*unitsquare,gray,black); }

    // Media columna izquierda
    for (int i=Num-1 ; i>Num/2 ; --i)
        { filldraw(shift((0,i)+Base)*unitsquare,gray,black); }
    }

// Desplazamiento de los textos
real Despl=-0.5;

// Primer mosaico
Mosaico(3, (0,0));
label("Mosaico 1",(1.5,Despl),fontsize(12pt)+black);

// Segundo mosaico
Mosaico(5, (4,0));
label("Mosaico 2",(6.5,Despl),fontsize(12pt)+black);

// Tercer mosaico
Mosaico(7, (10,0));
label("Mosaico 3",(13.5,Despl),fontsize(12pt)+black);
