//---------------------------------------------------------------
// Fichero:  pendiente.asy
// Objetivo: Mostrar cómo calcular la pendiente
// Fecha:    D.19.3.2023
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(6cm);

// Dimensiones de los ejes
real Xmin = 0, Xmax = 6, Ymin = 0, Ymax = 3.25, Extra = 0.25;

// Grosor de las líneas
defaultpen(1);

// El eje de ordenadas
draw((0,Ymin-Extra) -- (0,Ymax+Extra), gray);

// El eje de abscisas
draw((Xmin-Extra,0) -- (Xmax+Extra,0), gray);

// La gráfica
pair A=(1,1), B=(5,3);
pair V=B-A;
draw(A+1.2*V -- B-1.3*V);

// Los incrementos
pair C=(5,1);
draw(A -- C -- B,heavygreen);

// Dos puntos
label("$P_{1}$",A,NW);
label("$P_{2}$",B,NW);
dot(A,3pt+red);
dot(B,3pt+red);

// La separación entre las flechas y el objeto
real Separacion = 0.3;

// Las flechas que marcan los incrementos
draw(A-(0,Separacion) -- C-(0,Separacion),
     0.75bp+blue, Arrow(HookHead,5bp), Bars(1.5mm));
draw(C+(Separacion,0) -- B+(Separacion,0),
     0.75bp+blue, Arrow(HookHead,5bp), Bars(1.5mm));

// Los valores
label("$\Delta x=x_{2}-x_{1}$", (A+C)/2-(0,2*Separacion), fontsize(8pt));
label("$\Delta y=$", (C+B)/2+(4*Separacion,0.25), fontsize(8pt));
label("$y_{2}-y_{1}$", (C+B)/2+(4*Separacion,-0.25), fontsize(8pt));

// Las marcas de los ejes
draw((A.x,0.05)--(A.x,-0.05),1pt+blue);
label("$x_{1}$",(A.x,0),S);
draw((B.x,0.05)--(B.x,-0.05),1pt+blue);
label("$x_{2}$",(B.x,0),S);
draw((0.05,A.y)--(-0.05,A.y),1pt+blue);
label("$y_{1}$",(0,A.y),W);
draw((0.05,B.y)--(-0.05,B.y),1pt+blue);
label("$y_{2}$",(0,B.y),W);
