//---------------------------------------------------------------
// Fichero:  pendiente.asy
// Objetivo: Mostrar la pendiente
// Fecha:    M.14.3.2023
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// grid()
import math;

// xaxis(), yaxis()
import graph;

// fontsize()
import fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5.8cm);

// Dimensiones de los ejes
real Xmin = -8, Xmax = 8, Ymin = -7, Ymax = 4, Extra = 0.25;

// Rejilla de ayuda
add(shift(Xmin,Ymin)*grid((int)(Xmax-Xmin),(int)(Ymax-Ymin),0.3bp+gray));

// Grosor de las líneas
defaultpen(1);

// Formato de marcas de los dos ejes
ticks FormatoTicks = Ticks(Step=1, NoZero, Size=0.5mm, pTick=blue);

// Formato de texto de los dos ejes
pen FormatoTexto = blue+fontsize(4pt);

// El eje de ordenadas
yaxis(ymin=Ymin, ymax=Ymax, FormatoTexto, FormatoTicks);
draw((0,Ymin-Extra) -- (0,Ymax+Extra), gray);

// El eje de abscisas
xaxis(xmin=Xmin, xmax=Xmax, FormatoTexto, FormatoTicks);
draw((Xmin-Extra,0) -- (Xmax+Extra,0), gray);

// Puntos
pair A=(0,-2), B=(5,1);

// Los incrementos
pair C=(5,-2);
draw(A -- C,heavygreen,Arrow(HookHead,3bp));
draw(C -- B,heavygreen,Arrow(HookHead,3bp));

// La gráfica
draw((-8,-6.8)--(8,2.8));

// Dos puntos
pen Negrita=Helvetica(series="b",shape="n");
dot(Label("A",Negrita+fontsize(8pt)+heavygreen),A,NW,3pt+red);
dot(Label("B",Negrita+fontsize(8pt)+heavygreen),B,NW,3pt+red);

// Los valores
real Separacion = 0.4;
label("5", (A+C)/2-(0,Separacion), Negrita+fontsize(8pt)+deepgreen);
label("3", (C+B)/2+(Separacion,0), Negrita+fontsize(8pt)+deepgreen);
