//---------------------------------------------------------------
// Fichero:  solucion.asy
// Objetivo: Dar la solución de la representación gráfica
// Fecha:    D.26.2.2023
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// grid()
import math;

// xaxis(), yaxis()
import graph;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(8.8cm);

// Dimensiones de los ejes
real Xmin = 0, Xmax = 125, Ymin = 0, Ymax = 50, Extra = 1;

// Rejilla de ayuda
add(scale(5)*grid(25,10,0.3bp+gray));

// Grosor de las líneas
defaultpen(1);

// Formato de marcas de los ejes
ticks FormatoTicksX = Ticks(Step=25, Size=0.5mm, step=5, size=0.25mm,
                            NoZero, pTick=blue);
ticks FormatoTicksY = Ticks(Step=5, Size=0.25mm, NoZero, pTick=blue);

// Formato de texto de los dos ejes
pen FormatoTexto = blue+fontsize(6pt);

// El eje de ordenadas
yaxis(ymin=Ymin, ymax=Ymax, FormatoTexto, FormatoTicksY);
draw((0,Ymin-Extra) -- (0,Ymax+Extra), gray);

// El eje de abscisas
xaxis(xmin=Xmin, xmax=Xmax, FormatoTexto, FormatoTicksX);
draw((Xmin-Extra,0) -- (Xmax+Extra,0), gray);

// La gráfica
draw((0,0)--(Xmax,Ymax));
