#!/usr/bin/python
# coding: utf-8

#--------------------------------------------------------------------
# Fichero:  luz.py
# Objetivo: Calcular el tiempo de luz diario según la latitud
# Autor:    Pedro Reina <pedro@pedroreina.net>
# Fecha:    S.25.2.2023
# Atención: solo se ha probado en Python 2.7
# Licencia: CC0 1.0 Universal
#           https://creativecommons.org/publicdomain/zero/1.0/
# Uso:      luz.py latitud
# Ejemplo:  luz.py -75
#--------------------------------------------------------------------

#------------------------------------------------
# Módulos necesarios
#------------------------------------------------

# Para leer la línea de órdenes
import sys

# Para hacer los cálculos astronómicos
import ephem

#------------------------------------------------
# Constante del programa
#------------------------------------------------

# El día 1 de enero del año del que obtendremos los datos
FechaInicial = '2023/1/1'

#------------------------------------------------
# Variables globales
#------------------------------------------------

# El observador
Observador = ephem.Observer()

# La latitud
Latitud = 0

#------------------------------------------------
# Funciones
#------------------------------------------------

#------------------------------------------------
# Crea el observador de la latitud pedida
def CreaObservador():

    # La longitud es indiferente para este programa
    Observador.lon = 0

    # La latitud la hemos leído de la línea de órdenes
    Observador.lat = Latitud

    # Elevación
    Observador.elev = 0

#------------------------------------------------
# Devuelve el Date de un día (0..365) del año
def DateDia(Dia):
    return ephem.Date(FechaInicial)+Dia

#------------------------------------------------
# Convierte una fecha y hora en horas con un decimal
def Horas(Fecha):
    # Nos quedamos con la hora y nos olvidamos de la fecha
    HoraCompleta = Fecha.split()[1]

    # Descomponemos la hora en tres datos
    HorMinSeg = HoraCompleta.split(':')
    Hor = int(HorMinSeg[0])
    Min = float((HorMinSeg[1]))
    Seg = float(HorMinSeg[2])

    # Devolvemos el resultado
    return Hor + Min/60 + Seg/3600

#------------------------------------------------
# Devuelve el tiempo de luz en horas
def TiempoLuz():
    # Averiguamos cuándo amanece (puede que no lo haga)
    try:
        Amanecer = Horas(str(Observador.previous_rising(ephem.Sun())))
    except ephem.AlwaysUpError:
        Amanecer = 24
    except ephem.NeverUpError:
        Amanecer = 0

    # Averiguamos cuándo anochece (puede que no lo haga)
    try:
        Anochecer = Horas(str(Observador.next_setting(ephem.Sun())))
    except ephem.AlwaysUpError:
        Anochecer = 24
    except ephem.NeverUpError:
        Anochecer = 0

    # Calculamos el tiempo de luz
    if Amanecer == Anochecer:
        Respuesta = Amanecer
    else:
        Respuesta = round(Anochecer-Amanecer,1)

    # Lo devolvemos
    return Respuesta

#------------------------------------------------
# El programa
#------------------------------------------------

# Leemos la latitud de la línea de órdenes
Latitud = sys.argv[1]

# Creamos el observador
CreaObservador()

# Calculamos el tiempo de luz cada día
for Dia in range(0,366):

    # Le asignamos la fecha
    Observador.date = DateDia(Dia)

    # El tiempo de luz de este día
    print TiempoLuz(),
