//---------------------------------------------------------------
// Fichero:  funcionC.asy
// Objetivo: Representar la función C
// Fecha:    X.22.2.2023
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// grid()
import math;

// xaxis(), yaxis()
import graph;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(8.8cm);

// Dimensiones de los ejes
real Xmin = 0, Xmax = 60, Ymin = 0, Ymax = 35, Extra = 0.5;

// La letra del problema
label("C",(Xmin,Ymax),5*W);

// Rejilla de ayuda
int Escala=5;
int DimX=(int)((Xmax-Xmin)/Escala);
int DimY=(int)((Ymax-Ymin)/Escala);
add(shift(Xmin,Ymin)*scale(Escala)*grid(DimX,DimY,0.3bp+gray));

// Grosor de las líneas
defaultpen(1);

// Formato de marcas de los ejes
string Divide(real x) { return string(x/10); }
ticks FormatoTicksX = Ticks(ticklabel=Divide,
                            Step=10, step=5, NoZero,
                            Size=0.5mm, size=0.25mm, pTick=blue);
string Multiplica(real x) { return string(10*x); }
ticks FormatoTicksY = Ticks(ticklabel=Multiplica,
                            Step=5, Size=0.5mm,
                            NoZero, pTick=blue);

// Formato de texto de los dos ejes
pen FormatoTexto = blue+fontsize(6pt);

// El eje de ordenadas
yaxis(ymin=Ymin, ymax=Ymax, FormatoTexto, FormatoTicksY);
draw((0,Ymin-Extra) -- (0,Ymax+Extra), gray);

// El eje de abscisas
xaxis(xmin=Xmin, xmax=Xmax, FormatoTexto, FormatoTicksX);
draw((Xmin-Extra,0) -- (Xmax+Extra,0), gray);

// La gráfica
draw ((0,35)--(5,35)--(10,28)--(15,28)--(17,30)--
      (20,30)--(23,15)--(25,15)--(30,25)--(35,30)--(40,25)--
      (45,33)--(48,30)--(50,33)--(53,28)--(57,30)--(58,35)--(60,35));
