//---------------------------------------------------------------
// Fichero:  desarrollo.asy
// Objetivo: Representar el desarrollo de un problema
// Fecha:    L.23.1.2023
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(0,1.6cm);

// Grosor de las líneas
defaultpen(1);

// Construcción de la figura
int N=10;
real Ang=-360/(N-1);
real Desp=1.2;

// Generamos N imágenes
for (int i=0 ; i<N ; ++i)
  {
  // El cuadrado base
  path Cuadrado=shift(i*Desp,0)*unitsquare;

  // El centro del cuadrado
  pair T=(i*Desp+0.5,0.5);

  // El vértice superior izquierdo
  pair V=(i*Desp,1);

  // El punto que corre
  pair P=intersectionpoint(Cuadrado, T -- rotate(i*Ang,T)*V);

  // El área barrida
  path Area = T -- V;
  if (i>2) { Area=Area -- V+(1,0); }
  if (i>4) { Area=Area -- V+(1,-1); }
  if (i>6) { Area=Area -- V+(0,-1); }
  Area=Area -- P -- cycle;
  fill(Area,gray);

  // Los puntos
  dot(T,3pt+black);
  dot(V,3pt+black);
  dot(P,3pt+black);

  // El cuadrado
  draw(Cuadrado);

  // Los segmentos
  if (i==0 | i==N-1)
      { draw(V -- T); }
  else
      { draw(V -- T -- P); };
  }
