//---------------------------------------------------------------
// Fichero:  funcionD.asy
// Objetivo: Representar la función D
// Fecha:    X.1.2.2023
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// grid()
import math;

// xaxis(), yaxis(), graph()
import graph;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(8.5cm);

// Dimensiones de los ejes
real Xmin = -6, Xmax = 6, Ymin = -3, Ymax = 3, Extra = 0.5;

// La letra del problema
label("D",(Xmin,Ymax),NW);

// Rejilla de ayuda
add(shift(Xmin,Ymin)*grid((int)(Xmax-Xmin),(int)(Ymax-Ymin),0.3bp+gray));

// Grosor de las líneas
defaultpen(1);

// Formato de marcas de los dos ejes
ticks FormatoTicks = Ticks(Step=1, NoZero, Size=0.5mm, pTick=blue);

// Formato de texto de los dos ejes
pen FormatoTexto = blue+fontsize(4pt);

// El eje de ordenadas
yaxis(ymin=Ymin, ymax=Ymax, FormatoTexto, FormatoTicks);
draw((0,Ymin-Extra) -- (0,Ymax+Extra), gray);

// El eje de abscisas
xaxis(xmin=Xmin, xmax=Xmax, FormatoTexto, FormatoTicks);
draw((Xmin-Extra,0) -- (Xmax+Extra,0), gray);

// La gráfica
real D1(real x) { return (x^2-2); }
real D2(real x) { return ((x+4)^2-2); }
path Grafica1=graph(D1,-2,2,n=400);
path Grafica2=graph(D2,-6.1,-2,n=400);
draw(Grafica1);
draw(Grafica2);
draw((2,2)--(6.1,-2.1));
