//---------------------------------------------------------------
// Fichero:  propiedad1.asy
// Objetivo: Mostrar la propiedad 1
// Fecha:    V.21.4.2023
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// fontsize()
import fontsize;

// graph()
import graph;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(4cm);

// Grosor de las líneas
defaultpen(1);

// El eje de abscisas
draw((-1.5,0) -- (1.5,0), gray);

// La gráfica
real F(real x) { return (x^2-1); }
path Grafica=graph(F,-1.25,1.25,n=100);
draw(Grafica);

// El eje
pen Punteado = linetype(new real[] {2,2});
draw((0,-1.2) -- (0,0.7), Punteado+blue);

// Los puntos
int Abs[]={-1,0,1};
for ( int i=0 ; i<Abs.length ; ++i )
  { dot((Abs[i],F(Abs[i])),3bp+red); }

// Las flechas
real Separacion = 0.15;
pen FormatoFlecha=0.5bp+deepgreen;
draw((-1,Separacion) -- (-0.05,Separacion),
     FormatoFlecha, Arrows(HookHead,3bp), Bars(1mm));
draw((0.05,Separacion) -- (1,Separacion),
     FormatoFlecha, Arrows(HookHead,3bp), Bars(1mm));

// Las distancias
pen FormatoEtiqueta=blue+fontsize(6pt)+Bookman(series="b",shape="n");
label("d",(-0.5,2*Separacion),FormatoEtiqueta);
label("d",(0.5,2*Separacion),FormatoEtiqueta);
