//---------------------------------------------------------------
// Fichero:  ejemplo2.asy
// Objetivo: Mostrar el ejemplo 2
// Fecha:    L.19.12.2022
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// xaxis(), yaxis()
import graph;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5.9cm);

// Dimensiones de los ejes
real Xmin = -4, Xmax = 4, Ymin = -2, Ymax = 4, Extra = 0.25;

// Grosor de las líneas
defaultpen(1);

// Formato de marcas de los dos ejes
ticks FormatoTicks = Ticks(Step=1, NoZero, Size=0.5mm, pTick=blue);

// Formato de texto de los dos ejes
pen FormatoTexto = blue+fontsize(5pt);

// El eje de ordenadas
yaxis("", ymin=Ymin, ymax=Ymax, FormatoTexto, FormatoTicks);
draw((0,Ymin-Extra) -- (0,Ymax+Extra));

// El eje de abscisas
xaxis("", xmin=Xmin, xmax=Xmax, FormatoTexto, FormatoTicks);
draw((Xmin-Extra,0) -- (Xmax+Extra,0));

// Formato de etiquetas
pen Formato=fontsize(10pt)+deepgreen;

// Primera recta
draw((-4,-0.5) -- (4,3.5));
label("$x-2y=-3$",(4,3.5),E,Formato);

// Segunda recta
draw((-1,4) -- (4,-1));
label("$x+y=3$",(4,-1),E,Formato);

// Punto de intersección
dot((1,2),3bp+deepgreen);
