//---------------------------------------------------------------
// Fichero:  solucion.asy
// Objetivo: Mostrar la solución
// Fecha:    S.17.12.2022
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// grid()
import math;

// xaxis(), yaxis()
import graph;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(6cm);

// Dimensiones de los ejes
real Xmin = -4, Xmax = 7, Ymin = -1, Ymax = 5, Extra = 0.25;

// Rejilla de ayuda
add(shift(Xmin,Ymin)*grid((int)(Xmax-Xmin),(int)(Ymax-Ymin),0.25bp+gray));

// Grosor de las líneas
defaultpen(1);

// Formato de marcas de los dos ejes
ticks FormatoTicks = Ticks(Step=1, NoZero, Size=0.5mm, pTick=blue);

// Formato de texto de los dos ejes
pen FormatoTexto = blue+fontsize(5pt);

// El eje de ordenadas
yaxis("y", ymin=Ymin, ymax=Ymax, FormatoTexto, FormatoTicks);
draw((0,Ymin-Extra) -- (0,Ymax+Extra));

// El eje de abscisas
xaxis("x", xmin=Xmin, xmax=Xmax, FormatoTexto, FormatoTicks);
draw((Xmin-Extra,0) -- (Xmax+Extra,0));

// Los puntos de la primera recta
pair A=(-3,0), B=(0,1);

// Las expansiones la primera recta
real ExpIzq=0.2, ExpDer=2.2;

// La primera recta
draw(A+ExpIzq*(A-B) -- B+ExpDer*(B-A));
draw(A,cyan+3pt);
draw(B,cyan+3pt);

// Los puntos de la segunda recta
pair A=(0,4), B=(6,0);

// Las expansiones la segunda recta
real ExpIzq=0.15, ExpDer=0.1;

// La segunda recta
draw(A+ExpIzq*(A-B) -- B+ExpDer*(B-A));
draw(A,cyan+3pt);
draw(B,cyan+3pt);

// El punto de intersección
draw((3,2),heavygreen+4pt);
