#!/usr/bin/python
# coding: utf-8

#--------------------------------------------------------------------
# Fichero:  prepara.py
# Objetivo: Prepara un ejercicio de comprrobación del teorema del resto
# Autor:    Pedro Reina <pedro@pedroreina.net>
# Fecha:    L.26.9.2022
# Atención: solo se ha probado en Python 2.7
# Licencia: Dominio público
#           https://creativecommons.org/publicdomain/zero/1.0/
# Ejemplo:  polinomio: x²+5x-3; número: -7
#           prepara.py 1 5 -3 -7
#--------------------------------------------------------------------

#------------------------------------------------
# Módulos
#------------------------------------------------

# Para leer la línea de órdenes
import sys

#------------------------------------------------
# Constantes
#------------------------------------------------

Exp = u'⁰¹²³⁴⁵⁶⁷⁸⁹'

#------------------------------------------------
# Funciones
#------------------------------------------------

#------------------------------------------------
def Explica(Lista):

    if all(m==0 for m in Lista):
        Respuesta = '0'

    else:
        Respuesta = ''
        for i,m in enumerate(Lista):
            Potencia = len(Lista)-1-i

            if m<>0:
                Signo = ''
                if m<0:
                    Signo = u'−'
                    m = -m
                elif i<>0: Signo = '+'

                Coeficiente = str(m) if m<>1 or Potencia==0 else ''
                Letra = '' if Potencia==0 else 'x'
                Exponente = '' if Potencia<2 else Exp[Potencia]

                Respuesta += Signo + Coeficiente + Letra + Exponente

    return Respuesta

#------------------------------------------------
def Calcula(Lista, Num):
    Respuesta = 0

    for i,m in enumerate(Lista):
        Potencia = len(Lista)-1-i
        Respuesta += m*pow(Num,Potencia)

    return Respuesta

#------------------------------------------------
def Representa(Num):
    Respuesta = ''
    if Num<0: Respuesta += u'−'
    Respuesta += str(abs(Num))
    return Respuesta

#------------------------------------------------
# El programa
#------------------------------------------------

# Leemos los datos de la línea de órdenes
Datos = sys.argv[1:]

# Obtenemos el polinomio y el número
Polinomio = map(int,Datos[:-1])
Numero = int(Datos[-1])

# Calculamos el valor numérico
Resultado = Calcula(Polinomio,Numero)

# Damos el enunciado y la solución
print 'P(x)=' + Explica(Polinomio) + ';',
print 'a=' + Representa(Numero)
print Representa(Resultado)
