#!/usr/bin/python
# coding: utf-8

#--------------------------------------------------------------------
# Fichero:  prepara.py
# Objetivo: Prepara un ejercicio de cociente de polinomios
# Autor:    Pedro Reina <pedro@pedroreina.net>
# Fecha:    V.7.1.2022
# Atención: solo se ha probado en Python 2.7
# Licencia: Dominio público
#           https://creativecommons.org/publicdomain/zero/1.0/
# Ejemplo:  divisor: x²+5x-3; cociente: 2x²+1; resto: 4x-7
#           prepara.py 1 5 -3 , 2 0 1 , 4 -7
#--------------------------------------------------------------------

#------------------------------------------------
# Módulos
#------------------------------------------------

# Para leer la línea de órdenes
import sys

#------------------------------------------------
# Constantes
#------------------------------------------------

Exp = u'⁰¹²³⁴⁵⁶⁷⁸⁹'

#------------------------------------------------
# Funciones
#------------------------------------------------

#------------------------------------------------
def Explica(Lista):

    if all(m==0 for m in Lista):
        Respuesta = '0'

    else:
        Respuesta = ''
        for i,m in enumerate(Lista):
            Potencia = len(Lista)-1-i

            if m<>0:
                Signo = ''
                if m<0:
                    Signo = u'−'
                    m = -m
                elif i<>0: Signo = '+'

                Coeficiente = str(m) if m<>1 or Potencia==0 else ''
                Letra = '' if Potencia==0 else 'x'
                Exponente = '' if Potencia<2 else Exp[Potencia]

                Respuesta += Signo + Coeficiente + Letra + Exponente

    return Respuesta

#------------------------------------------------
# El programa
#------------------------------------------------

# Leemos los datos de la línea de órdenes
Datos = sys.argv[1:]

# Averiguamos dónde están los separadores de los polinomios
Sep1 = Datos.index(',')
Sep2 = Datos.index(',', Sep1+1)

# Obtenemos los tres polinomios
Divisor = map(int,Datos[:Sep1])
Cociente = map(int,Datos[Sep1+1:Sep2])
Resto = map(int,Datos[Sep2+1:])

# La lista que tendrá el dividendo
Dividendo = [0] * (len(Divisor)+len(Cociente)-1)

# Multiplicamos el divisor y el cociente
# (vamos multiplicando monomio a monomio y sumando en el dividendo)
for i,m1 in enumerate(Divisor):
    for j,m2 in enumerate(Cociente):
        Dividendo[i+j] += m1*m2

# Sumamos el resto al producto recién calculado
Desplazamiento = len(Dividendo)-len(Resto)
for i,m in enumerate(Resto):
    Dividendo[i+Desplazamiento] += m

# Damos el resultado
print 'Dividendo: ' + Explica(Dividendo) + ';',
print 'divisor: ' + Explica(Divisor)
print 'Cociente: ' + Explica(Cociente) + ';',
print 'resto: ' + Explica(Resto)
