//---------------------------------------------------------------
// Fichero:  cono.asy
// Objetivo: Mostrar el cono
// Fecha:    M.12.4.2022
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// cone()
import solids;

// Obtendremos un archivo PNG
settings.outformat="png";
settings.render=10;

// Tamaño de la imagen
size(0,3cm);

// Punto de proyección
currentprojection=orthographic((0,5,2),Z);

// Datos de la figura
real Radio=2, Altura=2;

// El cuerpo de revolución
triple T=(0,0,0), V=(0,0,Altura), R=(-Radio,0,0);
revolution Cono=cone(T,Radio,Altura,axis=Z,n=2);

// Marcamos la base
skeleton Corte;
Cono.transverse(Corte,reltime(Cono.g,0.5),P=currentprojection);
draw(shift(-Altura*Z)*scale3(2)*Corte.transverse.back,
     1bp+gray+linetype("2 2",8));

// Marcamos el contorno
draw(Cono.silhouette(),1bp+black);

// Los tres puntos que marcamos
dot(T,blue);
dot(V,blue);
dot(R,blue);

// La altura
draw(V--T,blue);
label("2r",(V+T)/2+0.3*X,blue);

// El radio de la base
draw(T--R,blue);
label("2r",(T+R)/2-0.75*Y,blue);
