//---------------------------------------------------------------
// Fichero:  desarrollo.asy
// Objetivo: Mostrar el dearrolo lateral del cilindro
// Fecha:    L.11.4.2022
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(6cm);

// Datos de la figura
real Radio=1, Altura=2;
real Perimetro=2*3.14*Radio;

// Formato de texto
pen Formato=blue+fontsize(12pt);

// El rectángulo
path Poli=box((0,0),(Perimetro,Altura));
draw(Poli,1bp+black);
real Separacion = 0.3;
draw((0,-Separacion) -- (Perimetro,-Separacion),
     blue, Arrows(HookHead,5bp), Bars(2mm));
label("$2·\pi·r$", (Perimetro/2,-2*Separacion), Formato);
draw((Perimetro+Separacion,0) -- (Perimetro+Separacion,Altura),
     blue, Arrows(HookHead,5bp), Bars(2mm));
label("$2·r$", (Perimetro+2*Separacion,Altura/2), Formato);

label("$4·\pi·r^2$", (Perimetro/2,Altura/2), Formato);
