//---------------------------------------------------------------
// Fichero:  cono3d.asy
// Objetivo: Mostrar un cono
// Fecha:    V.8.4.2022
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// cone()
import solids;

// Obtendremos un archivo PNG
settings.outformat="png";
settings.render=6;

// Tamaño de la imagen
size(4.8cm);

// Punto de proyección
currentprojection=orthographic((5,2,2),Z);

// Datos de la figura
real Radio=1, Altura=1;

// El cuerpo de revolución
triple T=(0,0,0), V=(0,0,Altura), R=(Radio,0,0);
revolution Cono=cone(T,Radio,Altura,axis=Z,n=2);
draw(surface(Cono),lightgray);

// Marcamos el contorno
draw(Cono.silhouette(),1bp+black);
