//---------------------------------------------------------------
// Fichero:  elementos.asy
// Objetivo: Mostrar los elementos del cono
// Fecha:    X.6.4.2022
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// cone()
import solids;

// Caracteres unicode
import unicode;

// Obtendremos un archivo PNG
settings.outformat="png";
settings.render=6;

// Tamaño de la imagen
size(4.8cm);

// Punto de proyección
currentprojection=orthographic((5,4,2),Z);

// Datos de la figura
real Radio=4, Altura=7;

// El cuerpo de revolución
triple T=(0,0,0), V=(0,0,Altura), R=(Radio,0,0);
revolution Cono=cone(T,Radio,Altura,axis=Z,n=2);

// Marcamos la base
skeleton Corte;
Cono.transverse(Corte,reltime(Cono.g,0.5),P=currentprojection);
draw(shift(-Altura*Z)*scale3(2)*Corte.transverse.back,
     1bp+black+linetype("4 4",8));

// Marcamos el contorno
draw(Cono.silhouette(),1bp+black);

// Los tres puntos que marcamos
dot(T,3bp+blue);
dot(V,3bp+blue);
dot(R,3bp+blue);

// Formato de texto
pen Formato=Helvetica(series="m",shape="n")+fontsize(3mm)+blue;

// El vértice
label("Vértice",V+0.5*Z,Formato);

// La altura
draw(V--T,1.5bp+blue);
label(rotate(90)*"Altura",(V+T)/2+0.5*Y,Formato);

// La generatriz
draw(V--R,1.5bp+blue);
label(rotate(72)*"Generatriz",(V+R)/2-0.5*Y,Formato);
