//---------------------------------------------------------------
// Fichero:  cono3d-rgh.asy
// Objetivo: Mostrar la relación entre los elementos del cono
// Fecha:    J.7.4.2022
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// cone()
import solids;

// Obtendremos un archivo PNG
settings.outformat="png";
settings.render=6;

// Tamaño de la imagen
size(4.8cm);

// Punto de proyección
currentprojection=orthographic((5,4,2),Z);

/////////////////////////////////////////
// https://asy.marris.fr/asymptote/Positions_relatives/index.html
//         #fig_pa01_251211_plan_droite_perpendiculaires
void angledroit(picture pic=currentpicture,
                triple pO, triple pI, triple pJ, real size=.5, pen p=black,
                projection P=currentprojection){
     triple imI=pO+size*unit(pI-pO),
            imJ=pO+size*unit(pJ-pO),
            imK=imI+imJ-pO;
            draw(imI--imK--imJ,p);
}
/////////////////////////////////////////

// Datos de la figura
real Radio=4, Altura=5;

// El cuerpo de revolución
triple T=(0,0,0), V=(0,0,Altura), R=(Radio,0,0);
revolution Cono=cone(T,Radio,Altura,axis=Z,n=2);

// Marcamos la base
skeleton Corte;
Cono.transverse(Corte,reltime(Cono.g,0.5),P=currentprojection);
draw(shift(-Altura*Z)*scale3(2)*Corte.transverse.back,
     1bp+gray+linetype("4 4",8));

// Marcamos el contorno
draw(Cono.silhouette(),1bp+black);

// Los tres puntos que marcamos
dot(T,3bp+red);
dot(V,3bp+red);
dot(R,3bp+red);

// El ángulo recto
angledroit(T,V,R,0.5,1bp+red);

// Formato de texto
pen Formato=Helvetica(series="m",shape="n")+fontsize(3mm)+blue;

// La altura
draw(V--T,1.5bp+red);
label(rotate(90)*"Altura",(V+T)/2+0.5*Y,Formato);

// La generatriz
draw(V--R,1.5bp+red);
label(rotate(66)*"Generatriz",(V+R)/2-0.5*Y,Formato);

// El radio de la base
draw(T--R,1.5bp+red);
label(rotate(20)*"Radio",(T+R)/2+0.75*Y,Formato);
