//---------------------------------------------------------------
// Fichero:  triangulos5.asy
// Objetivo: Mostrar cinco triángulos equiláteros unidos
// Fecha:    V.25.3.2022
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(3cm);

// Grosor de las líneas
defaultpen(1);

// Las constantes
int NumPol=5, NumLad=3;

// El polígono regular principal
path Poligono=polygon(NumLad);

// El centro de giro
pair T=point(Poligono,0);

// El ángulo de giro
real Angulo=180*(NumLad-2)/NumLad;

// Los puntos para marcar la flecha
pair A, B, M;

// Los polígonos
for ( int i=0 ; i<NumPol ; ++i )
    {
    path Girado=rotate((i+3)*Angulo,T)*Poligono;
    draw(Girado);
    if ( i == 0 )        { A=point(Girado,1); }
    if ( i == NumPol-1 ) { B=point(Girado,NumLad-1); }
    }

// La flecha
A=T+(A-T)/2; B=T+(B-T)/2; M=(A+B)/1.75;
draw(A..M..B,1bp+gray,ArcArrow(SimpleHead));
